#include "digirule2.h"

void lamp_test( void )
{
	ADDRESS_LEDS = 0b01010101;
	DATA_LEDS    = 0b10101010;

	for( uint8 i = 16; i != 0; i-- )
	{
		sleep_ms( 75 );
		ADDRESS_LEDS = ~ADDRESS_LEDS;
		DATA_LEDS	 = ~DATA_LEDS;
		RUN_LED		 = ~RUN_LED;
	}

	ADDRESS_LEDS = pc;
	DATA_LEDS = RAM[pc];
	RUN_LED = 0;
}

// use this function sparingly, and only when blocking all other processes is acceptable
void sleep_ms( uint8 ms )
{
	while( ms-- )
		for( TMR2IF = 0; TMR2IF == 0; )
			;
}

// this table logarithmically translates a SPEED instruction parameter (0..255) to an instruction execution rate (0..1000 milliseconds)
const uint16 speed_to_rate[] =
{
    0,		// 0
    1,		// 1
    2,		// 2
    3,		// 3
    3,		// 4
    4,		// 5
    5,		// 6
    5,		// 7
    6,		// 8
    7,		// 9
    8,		// 10
    8,		// 11
    9,		// 12
    10,		// 13
    11,		// 14
    11,		// 15
    12,		// 16
    13,		// 17
    14,		// 18
    14,		// 19
    15,		// 20
    16,		// 21
    17,		// 22
    17,		// 23
    18,		// 24
    19,		// 25
    20,		// 26
    21,		// 27
    21,		// 28
    22,		// 29
    23,		// 30
    24,		// 31
    25,		// 32
    25,		// 33
    26,		// 34
    27,		// 35
    28,		// 36
    29,		// 37
    29,		// 38
    30,		// 39
    31,		// 40
    32,		// 41
    33,		// 42
    34,		// 43
    35,		// 44
    35,		// 45
    36,		// 46
    37,		// 47
    38,		// 48
    39,		// 49
    40,		// 50
    41,		// 51
    41,		// 52
    42,		// 53
    43,		// 54
    44,		// 55
    45,		// 56
    46,		// 57
    47,		// 58
    48,		// 59
    49,		// 60
    50,		// 61
    51,		// 62
    51,		// 63
    52,		// 64
    53,		// 65
    54,		// 66
    55,		// 67
    56,		// 68
    57,		// 69
    58,		// 70
    59,		// 71
    60,		// 72
    61,		// 73
    62,		// 74
    63,		// 75
    64,		// 76
    65,		// 77
    66,		// 78
    67,		// 79
    68,		// 80
    69,		// 81
    70,		// 82
    71,		// 83
    72,		// 84
    73,		// 85
    74,		// 86
    75,		// 87
    76,		// 88
    78,		// 89
    79,		// 90
    80,		// 91
    81,		// 92
    82,		// 93
    83,		// 94
    84,		// 95
    85,		// 96
    86,		// 97
    88,		// 98
    89,		// 99
    90,		// 100
    91,		// 101
    92,		// 102
    93,		// 103
    95,		// 104
    96,		// 105
    97,		// 106
    98,		// 107
    99,		// 108
    101,	// 109
    102,	// 110
    103,	// 111
    104,	// 112
    106,	// 113
    107,	// 114
    108,	// 115
    109,	// 116
    111,	// 117
    112,	// 118
    113,	// 119
    115,	// 120
    116,	// 121
    117,	// 122
    119,	// 123
    120,	// 124
    121,	// 125
    123,	// 126
    124,	// 127
    125,	// 128
    127,	// 129
    128,	// 130
    130,	// 131
    131,	// 132
    133,	// 133
    134,	// 134
    136,	// 135
    137,	// 136
    139,	// 137
    140,	// 138
    142,	// 139
    143,	// 140
    145,	// 141
    146,	// 142
    148,	// 143
    150,	// 144
    151,	// 145
    153,	// 146
    154,	// 147
    156,	// 148
    158,	// 149
    160,	// 150
    161,	// 151
    163,	// 152
    165,	// 153
    166,	// 154
    168,	// 155
    170,	// 156
    172,	// 157
    174,	// 158
    176,	// 159
    177,	// 160
    179,	// 161
    181,	// 162
    183,	// 163
    185,	// 164
    187,	// 165
    189,	// 166
    191,	// 167
    193,	// 168
    195,	// 169
    197,	// 170
    199,	// 171
    201,	// 172
    204,	// 173
    206,	// 174
    208,	// 175
    210,	// 176
    213,	// 177
    215,	// 178
    217,	// 179
    220,	// 180
    222,	// 181
    224,	// 182
    227,	// 183
    229,	// 184
    232,	// 185
    234,	// 186
    237,	// 187
    240,	// 188
    242,	// 189
    245,	// 190
    248,	// 191
    250,	// 192
    253,	// 193
    256,	// 194
    259,	// 195
    262,	// 196
    265,	// 197
    268,	// 198
    271,	// 199
    275,	// 200
    278,	// 201
    281,	// 202
    285,	// 203
    288,	// 204
    291,	// 205
    295,	// 206
    299,	// 207
    302,	// 208
    306,	// 209
    310,	// 210
    314,	// 211
    318,	// 212
    322,	// 213
    326,	// 214
    331,	// 215
    335,	// 216
    340,	// 217
    345,	// 218
    349,	// 219
    354,	// 220
    359,	// 221
    365,	// 222
    370,	// 223
    375,	// 224
    381,	// 225
    387,	// 226
    393,	// 227
    400,	// 228
    406,	// 229
    413,	// 230
    420,	// 231
    427,	// 232
    435,	// 233
    443,	// 234
    451,	// 235
    460,	// 236
    470,	// 237
    479,	// 238
    490,	// 239
    500,	// 240
    512,	// 241
    525,	// 242
    538,	// 243
    552,	// 244
    568,	// 245
    585,	// 246
    604,	// 247
    625,	// 248
    650,	// 249
    677,	// 250
    710,	// 251
    750,	// 252
    802,	// 253
    875,	// 254
    1000,	// 255
};
